<?php
/* --------------------------------------------------------------
 ModulesConfigurationRepository.php 2020-01-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 24 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Compatibility;

use Gambio\Core\Configuration\Models\Read\ConfigurationGroupItem;

/**
 * Interface ModulesConfigurationRepository
 * @package Gambio\Core\Configuration\Compatibility
 */
interface ModulesConfigurationRepository
{
    /**
     * Returns a configuration entity by the given key (identifier).
     * $configurationKey will be prefixed with "configuration/" if not done already.
     *
     * @param string      $configurationKey
     * @param string      $module
     * @param string|null $customPrefix
     *
     * @return ConfigurationGroupItem
     */
    public function findByKey(
        string $configurationKey,
        string $module,
        string $customPrefix = null
    ): ConfigurationGroupItem;
    
    
    /**
     * Updates a configuration item.
     * $configurationKey will be prefixed with "configuration/" if not done already.
     *
     * @param string      $configurationKey
     * @param string      $value
     * @param string|null $customPrefix
     */
    public function updateConfiguration(string $configurationKey, string $value, string $customPrefix = null): void;
}